/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.tile.layout;

import com.google.inject.Singleton;
import java.util.LinkedHashSet;
import java.util.Set;
import technology.rocketjump.undermount.mapping.tile.layout.TileLayout;

@Singleton
public class TileLayoutAtlas {
    int[] simplifiedLayoutArray = new int[256];
    Set<Integer> uniqueLayouts = new LinkedHashSet<Integer>();

    public TileLayoutAtlas() {
        for (int layoutId = 0; layoutId < 256; ++layoutId) {
            TileLayout layoutForId = new TileLayout(layoutId);
            TileLayout simplified = layoutForId.reduceToMeaningfulForm();
            this.simplifiedLayoutArray[layoutId] = simplified.getId();
            this.uniqueLayouts.add(simplified.getId());
        }
    }

    public int simplifyLayoutId(int originalLayoutId) {
        return this.simplifiedLayoutArray[originalLayoutId];
    }

    public Set<Integer> getUniqueLayouts() {
        return this.uniqueLayouts;
    }
}

